var canvas = document.getElementById("artstect-canvas");
var ctx = canvas.getContext("2d");
var cw = canvas.width = window.innerWidth,
  cx = cw / 2;
var ch = canvas.height = window.innerHeight,
  cy = ch / 2;

  canvas.width = canvas.offsetWidth;
canvas.height = canvas.offsetHeight;

ctx.fillStyle = "#787D7B";
var linesRy = [];
var circlesRy = [];
if(cw < 500){
  var linesNum = randomIntFromInterval(1, 3);
  var circlesNum = randomIntFromInterval(1, 1);
}else{
  var linesNum = randomIntFromInterval(4, 6);
  var circlesNum = randomIntFromInterval(4, 6);
}
var requestId = null;


function Line(flag) {
  this.flag = flag;
  this.a = {};
  this.b = {};
  if (flag == "v") {
    this.a.y = 0;
    this.b.y = ch;
    this.a.x = randomIntFromInterval(0, ch);
    this.b.x = randomIntFromInterval(0, ch);
  } else if (flag == "h") {
    this.a.x = 0;
    this.b.x = cw;
    this.a.y = randomIntFromInterval(0, cw);
    this.b.y = randomIntFromInterval(0, cw);
  }
  this.va = randomIntFromInterval(25, 100) / 100;
  this.vb = randomIntFromInterval(25, 100) / 100;

  this.draw = function() {
    ctx.strokeStyle = "#787D7B";
    ctx.beginPath();
    ctx.moveTo(this.a.x, this.a.y);
    ctx.lineTo(this.b.x, this.b.y);
    ctx.stroke();
  }

  this.update = function() {
    if (this.flag == "v") {
      this.a.x += this.va;
      this.b.x += this.vb;
    } else if (flag == "h") {
      this.a.y += this.va;
      this.b.y += this.vb;
    }

    this.edges();
  }

  this.edges = function() {
    if (this.flag == "v") {
      if (this.a.x < 0 || this.a.x > cw) {
        this.va *= -1;
      }
      if (this.b.x < 0 || this.b.x > cw) {
        this.vb *= -1;
      }
    } else if (this.flag == "h") {
      if (this.a.y < 0 || this.a.y > ch) {
        this.va *= -1;
      }
      if (this.b.y < 0 || this.b.y > ch) {
        this.vb *= -1;
      }
    }
  }

}



function Circle() {
  this.r = randomIntFromInterval(25, 170);
  this.x = randomIntFromInterval(this.r, cw - this.r);
  this.y = randomIntFromInterval(this.r, ch - this.r);

  this.vx = randomIntFromInterval(25, 100)/100;
  this.vy = randomIntFromInterval(25, 100)/100;

  this.update = function() {
    this.edges();
    this.x += this.vx;
    this.y += this.vy;
  }

  this.edges = function() {
    if (this.x < this.r || this.x > cw - this.r) {
      this.vx *= -1;
    }
    if (this.y < this.r || this.y > ch - this.r) {
      this.vy *= -1;
    }
  }

  this.draw = function() {
    ctx.strokeStyle = "#787D7B";
    ctx.beginPath();
    ctx.arc(this.x, this.y, this.r, 0, 2 * Math.PI, true);
    ctx.stroke();
  }

}

for (var i = 0; i < circlesNum; i++) {
  var circle = new Circle();
  circlesRy.push(circle);
}

for (var i = 0; i < linesNum; i++) {
  var flag = i % 2 == 0 ? "h" : "v";
  var l = new Line(flag);
  linesRy.push(l);
}

console.log(circlesRy.length);

function Draw() {
  requestId = window.requestAnimationFrame(Draw);
  ctx.clearRect(0, 0, cw, ch);
  for (var i = 0; i < linesRy.length; i++) {
    var l = linesRy[i];
    l.draw();
    l.update();
  }
  for (var i = 0; i < linesRy.length; i++) {
    var l = linesRy[i];
    for (var j = i + 1; j < linesRy.length; j++) {
      var l1 = linesRy[j]
      Intersect2lines(l, l1);
    }
  }
  for (var i = 0; i < circlesRy.length; i++) {
    var c = circlesRy[i];
    c.update();
    c.draw();
  }
 for (var i = 0; i < circlesRy.length; i++) {
   var c = circlesRy[i];
    for (var j = i + 1; j < circlesRy.length; j++) {
      var c1 = circlesRy[j];
      var d = dist(c, c1);
      if ((d < c.r + c1.r) && (d > Math.abs(c.r - c1.r))) {
        getIntersection(c, c1, d);
      }
    }

    for (var j = 0; j < linesRy.length; j++) {
      var l = linesRy[j];
      var d = pDistance(c.x, c.y, l.a.x, l.a.y, l.b.x, l.b.y);
      if(d < c.r){
         var result_inteceptCircleLineSeg = inteceptCircleLineSeg(l, c);
         markPoint(result_inteceptCircleLineSeg[0]);
         markPoint(result_inteceptCircleLineSeg[1]);
      }
    }
  }
}

function pDistance(x, y, x1, y1, x2, y2) {

  var A = x - x1;
  var B = y - y1;
  var C = x2 - x1;
  var D = y2 - y1;

  var dot = A * C + B * D;
  var len_sq = C * C + D * D;
  var param = -1;
  if (len_sq != 0) //in case of 0 length line
      param = dot / len_sq;

  var xx, yy;

  if (param < 0) {
    xx = x1;
    yy = y1;
  }
  else if (param > 1) {
    xx = x2;
    yy = y2;
  }
  else {
    xx = x1 + param * C;
    yy = y1 + param * D;
  }

  var dx = x - xx;
  var dy = y - yy;
  return Math.sqrt(dx * dx + dy * dy);
}

function Init() {
  circlesRy.length = 0;
  for (var i = 0; i < circlesNum; i++) {
  var circle = new Circle();
  circlesRy.push(circle);
}

 for (var i = 0; i < linesNum; i++) {
    var flag = i % 2 == 0 ? "h" : "v";
    var l = new Line(flag);
    linesRy.push(l);
  }

  if (requestId) {
    window.cancelAnimationFrame(requestId);
    requestId = null;
  }

  cw = canvas.width = window.innerWidth,
    cx = cw / 2;
  ch = canvas.height = window.innerHeight,
    cy = ch / 2;

  Draw();
};

setTimeout(function() {
  Init();

  //addEventListener('resize', Init, false);
}, 25);

function getIntersection(p1, p2, d) {

  var p3 = {}; // middle point
  var p4 = {}; // intersection 1
  var p5 = {}; // intersection 2

  var a = (Math.pow(p1.r, 2) - Math.pow(p2.r, 2) + Math.pow(d, 2)) / (2 * d)
  var h = Math.sqrt(Math.pow(p1.r, 2) - Math.pow(a, 2));

  p3.x = p1.x + a * (p2.x - p1.x) / d;
  p3.y = p1.y + a * (p2.y - p1.y) / d;

  p4.x = p3.x + h * (p2.y - p1.y) / d;
  p4.y = p3.y - h * (p2.x - p1.x) / d;

  p5.x = p3.x - h * (p2.y - p1.y) / d;
  p5.y = p3.y + h * (p2.x - p1.x) / d;

  markPoint(p4);
  markPoint(p5);

}

function inteceptCircleLineSeg(line, circle){
    var a, b, c, d, u1, u2, ret, retP1, retP2, v1, v2;
    v1 = {};
    v2 = {};
    v1.x = line.b.x - line.a.x;
    v1.y = line.b.y - line.a.y;
    v2.x = line.a.x - circle.x;
    v2.y = line.a.y - circle.y;
    b = (v1.x * v2.x + v1.y * v2.y);
    c = 2 * (v1.x * v1.x + v1.y * v1.y);
    b *= -2;
    d = Math.sqrt(b * b - 2 * c * (v2.x * v2.x + v2.y * v2.y - circle.r * circle.r));
    if(isNaN(d)){ // no intercept
        return [];
    }
    u1 = (b - d) / c;  // these represent the unit distance of point one and two on the line
    u2 = (b + d) / c;    
    retP1 = {};   // return points
    retP2 = {}  
    ret = []; // return array
    if(u1 <= 1 && u1 >= 0){  // add point if on the line segment
        retP1.x = line.a.x + v1.x * u1;
        retP1.y = line.a.y + v1.y * u1;
        ret[0] = retP1;
    }
    if(u2 <= 1 && u2 >= 0){  // second add point if on the line segment
        retP2.x = line.a.x + v1.x * u2;
        retP2.y = line.a.y + v1.y * u2;
        ret[ret.length] = retP2;
    }       
    return ret;
}

function Intersect2lines(l1, l2) {
  var p1 = l1.a,
    p2 = l1.b,
    p3 = l2.a,
    p4 = l2.b;
  var denominator = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);
  var ua = ((p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x)) / denominator;
  var ub = ((p2.x - p1.x) * (p1.y - p3.y) - (p2.y - p1.y) * (p1.x - p3.x)) / denominator;
  var x = p1.x + ua * (p2.x - p1.x);
  var y = p1.y + ua * (p2.y - p1.y);
  if (ua > 0 && ub > 0) {
    markPoint({
      x: x,
      y: y
    })
  }
}

function dist(p1, p2) {
  var dx = p2.x - p1.x;
  var dy = p2.y - p1.y;
  return Math.sqrt(dx * dx + dy * dy);
}

function randomIntFromInterval(mn, mx) {
  return ~~(Math.random() * (mx - mn + 1) + mn)
}

function markPoint(p) {
  ctx.fillStyle = "#343434";
  ctx.beginPath();
  if(cw < 500){
    ctx.arc(p.x, p.y, 3, 0, 2 * Math.PI);
  }else{
    ctx.arc(p.x, p.y, 10, 0, 2 * Math.PI);
  }
  
  ctx.fill();
}