<?php

	add_action( 'wp_enqueue_scripts', 'ohio_child_local_enqueue_parent_styles' );

	function ohio_child_local_enqueue_parent_styles() {
		wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	}


// 依目前語系隱藏另一語言區塊
add_action('wp_head', function () {
    // 先抓語系代碼
    if (function_exists('pll_current_language')) {
        // Polylang：拿 slug（常見為 'zh'、'en'）
        $lang = pll_current_language('slug');
    } else {
        // 無 Polylang：用 WP 內建，取前兩碼
        $locale = function_exists('determine_locale') ? determine_locale() : get_locale();
        $lang = strtolower(substr($locale, 0, 2));
    }

    // 依語系輸出對應 CSS
    $css = '';
    if (in_array($lang, ['zh', 'zh-hant', 'zh-tw'])) {
        // 中文站：隱藏英文內容
        $css = '.lang-en{display:none !important;}';
    } elseif ($lang === 'en') {
        // 英文站：隱藏中文內容
        $css = '.lang-zh{display:none !important;}';
    }

    if ($css) {
        // 優先度很早地插入，減少 FOUC（畫面閃動）
        echo "<style id='lang-visibility-css'>{$css}</style>";
    }
}, 1);
