(function(){
  function initOne(root){
    if(!root) return;
    root.querySelectorAll('.va-carousel').forEach(carousel=>{
      if (carousel.dataset.initialized === 'true') return;
      carousel.dataset.initialized = 'true';

      const slides  = Array.from(carousel.querySelectorAll('.va-carousel__slide'));
      const prevBtn = carousel.querySelector('.va-carousel__prev');
      const nextBtn = carousel.querySelector('.va-carousel__next');
      const dots    = Array.from(carousel.querySelectorAll('.va-carousel__dot'));

      if (!slides.length) return;

      let index = slides.findIndex(s=>s.classList.contains('is-active'));
      if (index < 0) index = 0;

      const interval = parseInt(carousel.dataset.interval || '500', 10);
      const autoplay = (carousel.dataset.autoplay === '1' || carousel.dataset.autoplay === 'true');
      let timer = null;

      function render(i){
        slides.forEach((s,k)=>{
          const on = k===i;
          s.classList.toggle('is-active', on);
          s.setAttribute('aria-hidden', on ? 'false' : 'true');
        });
        dots.forEach((d,k)=>d.classList.toggle('is-active', k===i));
        index = i;
      }
      function go(delta){ render((index + delta + slides.length) % slides.length); }

      prevBtn && prevBtn.addEventListener('click', ()=>go(-1));
      nextBtn && nextBtn.addEventListener('click', ()=>go(+1));
      dots.forEach((d,k)=>d.addEventListener('click', ()=>render(k)));

      function start(){ if (autoplay && !timer) timer = setInterval(()=>go(+1), Math.max(1000, interval)); }
      function stop (){ if (timer){ clearInterval(timer); timer = null; } }

      carousel.addEventListener('mouseenter', stop);
      carousel.addEventListener('mouseleave', start);
      document.addEventListener('visibilitychange', ()=> document.hidden ? stop() : start());

      render(index);
      start();
    });
  }

  // 初次載入（文章頁等靜態內容）
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', ()=>initOne(document));
  } else {
    initOne(document);
  }

  // 🔑 關鍵：展覽頁動態載入後呼叫
  document.addEventListener('va:carousel:init', (e)=>{
    const scope = e.detail && e.detail.root ? e.detail.root : document;
    initOne(scope);
  });
})();
