<?php
/*
Plugin Name: Vanishing Acts Carousel
Description: Simple image carousel for Vanishing Acts project.
Version: 1.0.1
Author: 8f-2 Studio
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// Enqueue scripts and styles
function va_carousel_enqueue_assets() {
    $plugin_url = plugin_dir_url( __FILE__ );
    wp_enqueue_style(
        'va-carousel-css',
        $plugin_url . 'assets/va-carousel.css',
        array(),
        '1.0.2'
    );
    wp_enqueue_script(
        'va-carousel-js',
        $plugin_url . 'assets/va-carousel.js',
        array(),
        '1.0.2',
        true
    );
}
add_action( 'wp_enqueue_scripts', 'va_carousel_enqueue_assets' );

// Shortcode
function va_carousel_shortcode( $atts ) {
    $atts = shortcode_atts( array(
        'ids'      => '',
        'size'     => 'large',
        'autoplay' => '1',
        'interval' => '1000',
        'captions' => '1',
        'dots'     => '1',
        'arrows'   => '1',
        'aspect'   => '16:9',
    ), $atts, 'va_carousel' );

    if ( empty( $atts['ids'] ) ) return '';

    $ids = array_map( 'intval', explode( ',', $atts['ids'] ) );

    ob_start(); ?>
    <div class="va-carousel"
         tabindex="0"
         data-autoplay="<?php echo esc_attr($atts['autoplay']); ?>"
         data-interval="<?php echo esc_attr($atts['interval']); ?>"
         data-aspect="<?php echo esc_attr($atts['aspect']); ?>">

        <div class="va-carousel__viewport">
            <div class="va-carousel__track">
                <?php foreach ( $ids as $i => $id ) :
                    $src = wp_get_attachment_image_src( $id, $atts['size'] );
                    $caption = wp_get_attachment_caption( $id );
                    if ( ! $src ) continue; ?>
                    <figure class="va-carousel__slide <?php echo $i === 0 ? 'is-active' : ''; ?>"
                            data-index="<?php echo esc_attr($i); ?>"
                            aria-hidden="<?php echo $i === 0 ? 'false' : 'true'; ?>">
                        <img src="<?php echo esc_url($src[0]); ?>" alt="">
                        <?php if ( $atts['captions'] === '1' && $caption ) : ?>
                            <figcaption class="va-carousel__caption"><?php echo esc_html($caption); ?></figcaption>
                        <?php endif; ?>
                    </figure>
                <?php endforeach; ?>
            </div>
        </div>

        <?php if ( $atts['arrows'] === '1' ) : ?>
            <button class="va-carousel__btn va-carousel__prev" aria-label="Previous">&larr;</button>
            <button class="va-carousel__btn va-carousel__next" aria-label="Next">&rarr;</button>
        <?php endif; ?>

        <?php if ( $atts['dots'] === '1' ) : ?>
            <div class="va-carousel__dots">
                <?php foreach ( $ids as $i => $id ) : ?>
                    <button class="va-carousel__dot <?php echo $i === 0 ? 'is-active' : ''; ?>"
                            data-index="<?php echo esc_attr($i); ?>"
                            aria-label="Go to slide <?php echo esc_attr($i+1); ?>"></button>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode( 'va_carousel', 'va_carousel_shortcode' );

