(function(){
  function qs(s,ctx){ return (ctx||document).querySelector(s); }
  function qsa(s,ctx){ return Array.prototype.slice.call((ctx||document).querySelectorAll(s)); }

  // ====== Mobile bottom nav / More overlay（你原本的） ======
  function openMore(){ var o=qs('#va-more'); if(!o) return; o.hidden=false; o.setAttribute('aria-hidden','false'); document.body.style.overflow='hidden'; }
  function closeMore(){ var o=qs('#va-more'); if(!o) return; o.hidden=true;  o.setAttribute('aria-hidden','true');  document.body.style.overflow=''; }

  function smoothTo(hash){
    var el = qs(hash);
    if(!el) return;
    var y = el.getBoundingClientRect().top + window.scrollY - 12;
    window.scrollTo({ top:y, behavior:'smooth' });
  }

  function initMobNav(){
    var nav = qs('#va-mob-nav'); if(!nav) return;

    nav.addEventListener('click', function(e){
      var moreBtn = e.target.closest('[data-open-more]');
      if(moreBtn){ e.preventDefault(); openMore(); }
    });

    qsa('[data-close-more]').forEach(function(el){
      el.addEventListener('click', function(e){ e.preventDefault(); closeMore(); });
    });
    qs('#va-more')?.addEventListener('click', function(e){
      if(e.target.matches('.va-more__backdrop')) closeMore();
    });
    document.addEventListener('keydown', function(e){ if(e.key==='Escape') closeMore(); });

    qsa('[data-scroll]').forEach(function(a){
      a.addEventListener('click', function(e){
        var href = a.getAttribute('href')||'';
        if(href.startsWith('#') && href.length>1){
          e.preventDefault();
          if (a.hasAttribute('data-close-more')) closeMore();
          smoothTo(href);
        }
      });
    });
  }

  // ====== What's On：手機滑動 & 彈窗切換 ======
  function isMobile(){ return window.matchMedia('(max-width: 1199px)').matches; }

  // 1) 左側索引變滑動（每頁 4 張，可改 data-per-page）
  function setupWhatsonSlider(){
    var host = qs('#whatson-index');
    if(!host || !isMobile()) return;
    if (host.dataset.enhanced) return;

    var per = parseInt(host.getAttribute('data-per-page')||'4',10);
    var items = qsa('.va-link', host);
    if(!items.length) return;

    var slider = document.createElement('div'); slider.className='va-slider';

    for (var i=0; i<items.length; i+=per){
      var page = document.createElement('div'); page.className='va-slide';
      var grid = document.createElement('div'); grid.className='va-page';
      for (var j=i; j<i+per && j<items.length; j++){ grid.appendChild(items[j]); }
      page.appendChild(grid); slider.appendChild(page);
    }
    host.innerHTML=''; host.appendChild(slider);host.classList.add('is-slider');

    // dots
    var dots = document.createElement('div'); dots.className='va-dots';
    var pages = qsa('.va-slide', slider);
    pages.forEach(function(_, idx){
      var b=document.createElement('button'); b.setAttribute('aria-label','Go to page '+(idx+1));
      if(idx===0) b.classList.add('is-active');
      b.addEventListener('click', function(){ slider.scrollTo({left: idx * slider.clientWidth, behavior:'smooth'}); });
      dots.appendChild(b);
    });
    host.appendChild(dots);

    function updateDots(){
      var i = Math.round(slider.scrollLeft / slider.clientWidth);
      qsa('button', dots).forEach(function(d,k){ d.classList.toggle('is-active', k===i); });
    }
    slider.addEventListener('scroll', function(){ window.requestAnimationFrame(updateDots); });
    window.addEventListener('resize', updateDots);

    host.dataset.enhanced = '1';
  }

  // 2) 彈窗內 Prev/Next／豆豆／滑動
  function setupWhatsonModalNav(){
    var host = qs('#whatson-index'); if(!host) return;
    var links = qsa('.va-link', host); if(!links.length) return;
    if(!isMobile()) return;

    // key 陣列（依目前排序）
    var keys = links.map(function(el){
      var s = el.getAttribute('data-va-slug'), i = el.getAttribute('data-va-id');
      return s ? {type:'slug', value:s} : {type:'id', value:i};
    });

    // 豆豆（放到 va-map.js 的 ensureModal 建立的容器）
    (window.VA && window.VA.ensureModal) && window.VA.ensureModal();
    var dots = qs('.va-modal-dots');
    if (dots){
      dots.innerHTML='';
      keys.forEach(function(_, idx){
        var b=document.createElement('button');
        if(idx===0) b.classList.add('is-active');
        b.addEventListener('click', function(){ load(idx); });
        dots.appendChild(b);
      });
    }

    var cur = 0;
    function setDot(i){
      qsa('button', qs('.va-modal-dots')).forEach(function(b,k){ b.classList.toggle('is-active', k===i); });
    }

    function load(i){
      cur = (i + keys.length) % keys.length;
      var body = (window.VA && window.VA.openModal) ? window.VA.openModal('whatson') : document.querySelector('#va-modal-body');
      if (!body) return;
      (window.VA && window.VA.fetchAndInject) && window.VA.fetchAndInject(keys[cur], body);
      setDot(cur);
    }

    // 左右按鈕
    qs('.va-modal-prev')?.addEventListener('click', function(){ load(cur-1); });
    qs('.va-modal-next')?.addEventListener('click', function(){ load(cur+1); });

    // 手勢左右滑
    var startX=null;
    document.addEventListener('touchstart', function(e){
      if(qs('#va-modal[hidden]')) return; startX = e.touches[0].clientX;
    }, {passive:true});
    document.addEventListener('touchend', function(e){
      if(qs('#va-modal[hidden]') || startX===null) return;
      var dx = e.changedTouches[0].clientX - startX;
      if (Math.abs(dx) > 50){ load(cur + (dx<0 ? 1 : -1)); }
      startX = null;
    });

    // 手機：攔截縮圖點擊→開彈窗（避免桌機邏輯同時觸發）
    links.forEach(function(el, idx){
      el.addEventListener('click', function(ev){
        if(!isMobile()) return;
        var tgt = el.getAttribute('data-va-target')||'';
        if (tgt === '#va-pane-A'){
          ev.preventDefault();
          ev.stopImmediatePropagation();
          load(idx);
        }
      });
    });
  }

  function initWhatsOnMobile(){
    if (!isMobile()) return;
    setupWhatsonSlider();
    //setupWhatsonModalNav();
  }

  // ====== Init ======
  function init(){
    initMobNav();
    //initWhatsOnMobile();
    initTabletHamburger(); 
    initMobileSectionSwitcher();
  }

  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', init);
  else init();

  // 在檔案末尾新增以下函數
  function initTabletHamburger(){
    const hamburger = document.getElementById('va-hamburger');
    const sidebar = document.getElementById('va-sidebar');
    const overlay = document.getElementById('va-sidebar-overlay');
    
    if (!hamburger || !sidebar || !overlay) return;
    
    function openSidebar() {
      hamburger.classList.add('is-open');
      sidebar.classList.add('is-open');
      overlay.classList.add('is-open');
      document.body.style.overflow = 'hidden';
    }
    
    function closeSidebar() {
      hamburger.classList.remove('is-open');
      sidebar.classList.remove('is-open');
      overlay.classList.remove('is-open');
      document.body.style.overflow = '';
    }
    
    function toggleSidebar() {
      if (sidebar.classList.contains('is-open')) {
        closeSidebar();
      } else {
        openSidebar();
      }
    }
    
    // 事件監聽
    hamburger.addEventListener('click', toggleSidebar);
    overlay.addEventListener('click', closeSidebar);
    
    // 側邊欄連結點擊後關閉
    sidebar.addEventListener('click', function(e) {
      if (e.target.tagName === 'A' && window.innerWidth <= 1399) {
        closeSidebar();
      }
    });
    
    // ESC鍵關閉
    document.addEventListener('keydown', function(e) {
      if (e.key === 'Escape' && sidebar.classList.contains('is-open')) {
        closeSidebar();
      }
    });
    
    // 視窗大小改變時重置狀態
    window.addEventListener('resize', function() {
      if (window.innerWidth >= 1400) {
        closeSidebar();
      }
    });
  }

  // 在 va-mobile.js 檔案中新增手機版區段切換功能

// 在 va-mobile.js 中修改 initMobileSectionSwitcher 函數

function initMobileSectionSwitcher() {
  // 檢查是否為手機模式
  function isMobile() {
    return window.matchMedia('(max-width: 1199px)').matches;
  }
  
  if (!isMobile()) {
    console.log('非手機模式，跳過手機區段切換器');
    return;
  }
  
  console.log('初始化手機版區段切換器');
  
  // 定義區段映射關係
  const sectionMapping = {
    '#sec-about': 'about_index_sec',
    '#sec-whatson': 'whatson_index_sec', 
    '#sec-program': 'program_index_sec',
    '#sec-team': 'team_index_sec'
  };
  
  // 獲取所有可切換的區段
  const allSections = Object.values(sectionMapping);
  const allSectionElements = allSections.map(id => document.getElementById(id)).filter(Boolean);
  
  if (allSectionElements.length === 0) {
    console.log('找不到任何可切換的區段元素');
    return;
  }
  
  console.log('找到', allSectionElements.length, '個可切換區段:', allSections);
  
  // 隱藏所有區段的函數
  function hideAllSections() {
    allSectionElements.forEach(section => {
      section.style.display = 'none';
      console.log('隱藏區段:', section.id);
    });
  }
  
  // 顯示指定區段的函數 - 修復滾動位置
  function showSection(targetSectionId) {
    const targetElement = document.getElementById(targetSectionId);
    if (targetElement) {
      // 先隱藏所有區段
      hideAllSections();
      
      // 顯示目標區段
      targetElement.style.display = 'block';
      console.log('顯示區段:', targetSectionId);
      
      // *** 修復：確保滾動到頁面頂部，而不是底部 ***
      // 使用 setTimeout 確保 DOM 更新完成後再滾動
      setTimeout(() => {
        // 方法1：直接設置滾動位置到頂部
        window.scrollTo({
          top: 0,
          left: 0,
          behavior: 'smooth'
        });
        
        // 方法2：如果方法1不行，使用 scrollIntoView
        // targetElement.scrollIntoView({
        //   behavior: 'smooth',
        //   block: 'start',
        //   inline: 'nearest'
        // });
        
        console.log('已滾動到頁面頂部');
      }, 50); // 短暫延遲確保 DOM 渲染完成
      
      // 更新導航狀態
      updateNavState(targetSectionId);
      
      return true;
    } else {
      console.log('找不到目標區段:', targetSectionId);
      return false;
    }
  }
  
  // 更新導航按鈕狀態
  // 修改 updateNavState 函數
  function updateNavState(activeSectionId) {
      const navItems = document.querySelectorAll('.va-mob-nav__item');
      
      // 移除所有按鈕的 active 狀態
      navItems.forEach(item => {
          item.classList.remove('va-nav-active');
      });
      
      // 找到對應的導航按鈕並添加 active 狀態
      Object.entries(sectionMapping).forEach(([href, sectionId]) => {
          if (sectionId === activeSectionId) {
              // 修改：使用更精確的選擇器
              const activeNavItem = document.querySelector(`a.va-mob-nav__item[href="${href}"][data-scroll]`);
              if (activeNavItem) {
                  activeNavItem.classList.add('va-nav-active');
                  console.log('更新導航狀態:', href, '元素找到:', activeNavItem);
              } else {
                  console.warn('找不到導航按鈕:', href);
                  // 備用方案：嘗試其他選擇器
                  const backupNavItem = Array.from(navItems).find(item => 
                      item.getAttribute('href') === href && 
                      item.hasAttribute('data-scroll')
                  );
                  if (backupNavItem) {
                      backupNavItem.classList.add('va-nav-active');
                      console.log('使用備用選擇器找到:', href);
                  }
              }
          }
      });
  }
  
  // 初始化：只顯示 About 區段
  function initializeMobile() {
    console.log('手機版初始化：顯示 About 區段');
    showSection('about_index_sec');
  }
  
  // 綁定導航點擊事件
  function bindNavigationEvents() {
    // 處理底部導航按鈕
    Object.entries(sectionMapping).forEach(([href, sectionId]) => {
      const navButton = document.querySelector(`[href="${href}"][data-scroll]`);
      if (navButton) {
        navButton.addEventListener('click', function(e) {
          if (!isMobile()) return; // 非手機模式不處理
          
          e.preventDefault();
          e.stopPropagation();
          
          console.log('點擊導航按鈕:', href, '-> 顯示區段:', sectionId);
          showSection(sectionId);
        });
        
        console.log('已綁定導航按鈕:', href);
      }
    });
    
    // 處理 More 面板中的 Team 連結
    const moreTeamLink = document.querySelector('#va-more [href="#sec-team"][data-scroll]');
    if (moreTeamLink) {
      moreTeamLink.addEventListener('click', function(e) {
        if (!isMobile()) return;
        
        e.preventDefault();
        e.stopPropagation();
        
        console.log('點擊 More 面板中的 Team 連結');
        showSection('team_index_sec');
        
        // 關閉 More 面板
        closeMore();
      });
      
      console.log('已綁定 More 面板中的 Team 連結');
    }
  }
  
  // More 面板控制
  function closeMore() {
    const more = document.getElementById('va-more');
    if (more) {
      more.hidden = true;
      more.setAttribute('aria-hidden', 'true');
      document.body.style.overflow = '';
      console.log('關閉 More 面板');
    }
  }
  
  // 監聽視窗大小變化
  function handleResize() {
    const currentIsMobile = isMobile();
    
    if (currentIsMobile && !window.mobileSectionSwitcherActive) {
      // 切換到手機模式
      console.log('切換到手機模式，啟用區段切換器');
      initializeMobile();
      window.mobileSectionSwitcherActive = true;
    } else if (!currentIsMobile && window.mobileSectionSwitcherActive) {
      // 切換到非手機模式
      console.log('切換到非手機模式，停用區段切換器');
      // 恢復所有區段顯示
      allSectionElements.forEach(section => {
        section.style.display = '';
      });
      window.mobileSectionSwitcherActive = false;
    }
  }
  
  // 初始化
  bindNavigationEvents();
  initializeMobile();
  window.mobileSectionSwitcherActive = true;
  
  // 監聽視窗大小變化
  window.addEventListener('resize', handleResize);
  
  console.log('手機版區段切換器初始化完成');
}

// 修改原有的 init() 函數，加入手機版區段切換器
function init(){
  initMobNav();
  initWhatsOnMobile();
  initTabletHamburger();
  initMobileSectionSwitcher(); // 新增這行
}

// 為手機版導航按鈕添加 active 狀態樣式（加入 CSS）
const mobileNavActiveCSS = `
.va-mob-nav__item.va-nav-active {
  background: #23e2d0 !important;
  color: #000 !important;
  transform: translateY(-2px);
  box-shadow: 0 4px 8px rgba(236, 253, 0, 0.3);
}

.va-mob-nav__item {
  transition: all 0.3s ease;
}

@media (max-width: 1199px) {
  /* 確保手機模式下右側內容區域隱藏 */
  #about_content_sec,
  #whatson_content_sec, 
  #program_content_sec{
    display: none !important;
  }
  
  /* 確保左側區段可以完整顯示 */
  #about_index_sec,
  #whatson_index_sec,
  #program_index_sec, 
  #team_index_sec,
  #team_content_sec  {
    width: 100% !important;
    max-width: 100% !important;
    min-height:100vh;
  }
}
`;

// 將樣式注入到頁面
function injectMobileNavStyles() {
  const existingStyle = document.getElementById('mobile-nav-styles');
  if (!existingStyle) {
    const style = document.createElement('style');
    style.id = 'mobile-nav-styles';
    style.textContent = mobileNavActiveCSS;
    document.head.appendChild(style);
    console.log('已注入手機導航樣式');
  }
}

// 在 DOM 載入完成後注入樣式
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', injectMobileNavStyles);
} else {
  injectMobileNavStyles();
}


/* ===== Breakpoint manager: enter/exit handheld (<1200px) ===== */
(function () {
  const $  = (s,ctx)=> (ctx||document).querySelector(s);
  const $$ = (s,ctx)=> Array.prototype.slice.call((ctx||document).querySelectorAll(s));
  const isHandheld = () => window.matchMedia('(max-width: 1199px)').matches;

  // 這四個 index、四個 content 的 DOM id（照你的結構）
  const INDEX_IDS   = ['about_index_sec','whatson_index_sec','program_index_sec','team_index_sec'];
  const CONTENT_IDS = ['about_content_sec','whatson_content_sec','program_content_sec','team_content_sec'];

  /* ---------- MOBILE: 只顯示某一個 index、隱藏全部 content ---------- */
  function showOnlyIndex(indexIdToShow) {
    INDEX_IDS.forEach(id => {
      const el = document.getElementById(id);
      if (el) el.style.display = (id === indexIdToShow ? 'block' : 'none');
    });
    CONTENT_IDS.forEach(id => {
      const el = document.getElementById(id);
      if (el) el.style.display = 'none';
    });
    // 捲回頂端，避免還能一路滑到底
    window.scrollTo({ top: 0, behavior: 'instant' });
  }

  /* ---------- MOBILE: 底部導覽補上 active（若不存在） ---------- */
  function ensureMobNavActive() {
    const nav = document.getElementById('va-mob-nav');
    if (!nav) return;
    const active = nav.querySelector('.va-mob-nav__item.va-nav-active');
    if (!active) {
      const first = nav.querySelector('.va-mob-nav__item');
      first && first.classList.add('va-nav-active');
    }
  }

  /* ---------- MOBILE: What’s On 索引做滑動版（且可還原） ---------- */
  function buildWhatsonSliderIfNeeded() {
    const host = document.getElementById('whatson-index');
    if (!host || host.dataset.enhanced === '1') return;
    // 暫存原始 DOM，讓桌機還原
    host.dataset.originalHtml = host.innerHTML;
    // 呼叫你現有的手機滑動初始化（檔案裡已有）
    if (typeof setupWhatsonSlider === 'function') {
      setupWhatsonSlider();
    } else {
      // 你的檔案中 setupWhatsonSlider 是內部函式；若外部抓不到就直接模仿已產出的標記不處理
    }
  }

  function restoreWhatsonIndexIfNeeded() {
    const host = document.getElementById('whatson-index');
    if (!host) return;
    if (host.dataset.enhanced === '1' && host.dataset.originalHtml) {
      host.innerHTML = host.dataset.originalHtml;
      delete host.dataset.originalHtml;
      delete host.dataset.enhanced;
      host.classList.remove('is-slider');
    }
  }

  /* ---------- DESKTOP: 顯示全部 index & content；空白就補載預設 ---------- */
  function showAllSections() {
    INDEX_IDS.concat(CONTENT_IDS).forEach(id => {
      const el = document.getElementById(id);
      if (el) el.style.display = '';
    });
  }

  function ensureDesktopContentLoaded() {
    // 若 content 仍是空白，試著從 data-va-default-* 或對應 index 第一個 .va-link 裡抓 key 去載入
    CONTENT_IDS.forEach(cid => {
      const target = document.getElementById(cid);
      if (!target) return;

      const html = (target.innerHTML || '').trim();
      const looksEmpty = !html || /^(\s|<!--.*?-->)+$/.test(html);
      if (!looksEmpty) return;

      // 1) 先看 target 上有沒有 data-va-default
      let key = null;
      const slug = target.getAttribute('data-va-default-slug');
      const id   = target.getAttribute('data-va-default-id');
      if (slug) key = { type: 'slug', value: slug };
      else if (id) key = { type: 'id', value: id };

      // 2) 沒有的話，用對應的 index 的第一個 .va-link
      if (!key) {
        const idxId = cid.replace('_content_', '_index_'); // e.g. whatson_content_sec -> whatson_index_sec
        const firstLink = $(`#${idxId} .va-link`);
        if (firstLink) {
          const s = firstLink.getAttribute('data-va-slug');
          const i = firstLink.getAttribute('data-va-id');
          key = s ? { type:'slug', value:s } : (i ? { type:'id', value:i } : null);
        }
      }

      if (key && window.VA && typeof window.VA.fetchAndInject === 'function') {
        window.VA.fetchAndInject(key, target);
      }
    });
  }

  /* ---------- 斷點進場/退場 ---------- */
  let wasHandheld = isHandheld();

  function enterHandheld() {
    ensureMobNavActive();               // 狀況一-1
    showOnlyIndex('about_index_sec');   // 狀況一-2：一次只顯示一個 index，避免整頁直到底
    buildWhatsonSliderIfNeeded();       // 建立手機滑動（可還原）
  }

  function exitHandheld() {
    restoreWhatsonIndexIfNeeded(); // 把 is-slider 結構還原成桌機原樣（狀況二-2）
    showAllSections();             // 顯示所有 index + content
    ensureDesktopContentLoaded();  // content 空白就補載預設（狀況二-1）
  }

  function handleResize() {
    const now = isHandheld();
    if (now === wasHandheld) return;
    wasHandheld = now;
    if (now) enterHandheld();
    else exitHandheld();
  }

  // 首次進站就套一次
  if (wasHandheld) enterHandheld();

  // 監聽 resize
  window.addEventListener('resize', handleResize);
})();


})();
