<?php
/**
 * Ohio WordPress Theme
 *
 * Error 404 page template
 *
 * @author Colabrio
 * @link   https://ohio.clbthemes.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get theme options

$header_type = OhioOptions::get( 'page_header_menu_style', 'style1' );
$wrapper_boxed = OhioOptions::get( 'page_use_boxed_wrapper', false );
$show_footer = !OhioHelper::is_optimized_flow( 'footer' ) && !OhioSettings::is_coming_soon_page();
$search_visible = OhioOptions::get( 'page_header_search_visibility', true ) && !OhioSettings::is_coming_soon_page();

OhioOptions::get( 'page_header_search_visibility' ); // trigger selection chain
$style_settings_select_type = OhioOptions::get_last_select_type();
$search_position = OhioOptions::get_by_type( 'page_header_search_position', $style_settings_select_type );

?>

			</div>
			<?php
				if ( function_exists( 'elementor_theme_do_location' ) ) {
					$elementor_footer = elementor_theme_do_location( 'footer' );
					$show_footer = $show_footer && ! $elementor_footer;
				}
			?>

			<?php 
				if ( $show_footer ) {
					get_template_part( 'parts/elements/footer' );
				}
			?>

			<?php if ( $search_position == 'fixed' ) : ?>

			<div class="search-holder vc_hidden-xs">
				<?php get_template_part( 'parts/elements/search' ); ?>
			</div>

			<?php endif; ?>
		</div>

	<?php if ( $header_type == 'style6' ) : ?>

		</div>

	<?php endif; ?>

	<?php if ( $wrapper_boxed ) : ?>

		</div>

	<?php endif; ?>

	<?php get_template_part( 'parts/elements/notification' ); ?>
	<?php get_template_part( 'parts/elements/preloader' ); ?>
	<?php get_template_part( 'parts/elements/popup' ); ?>
	<?php get_template_part( 'parts/elements/subscribe_container' ); ?>

	<?php 
		if ( $search_visible ) {
			get_template_part( 'parts/elements/search_form' );
		}
	?>

	<?php
		// Some dynamic code place: popups, client JS, snippets...
		OhioLayout::get_footer_buffer_content( true );
		//OhioBuffer::stop_content_bufferization();
		OhioHelper::calculate_custom_fonts_inline();
		OhioLayout::show_shortcodes_inline_css(); // Include collected dynamic CSS to head
		//OhioBuffer::get_content_buffer(); // Return the rest of page code

		wp_footer();

		do_action( 'ohio_additional_page_layout', 10, 0 );
	?>

  <?php
  // 定義多語言文字
  $nav_texts = [
      'about' => [
          'zh' => '關於展覽',
          'en' => 'About',
          'es' => 'Acerca de'
      ],
      'whatson' => [
          'zh' => '立即探索',
          'en' => "What's On",
          'es' => "Obras"
      ],
      'program' => [
          'zh' => '公眾活動',
          'en' => 'Public Program',
          'es' => 'Programa Público'
      ],
      'more' => [
          'zh' => '更多',
          'en' => 'More',
          'es' => 'Más'
      ],
      'language' => [
          'zh' => '語言',
          'en' => 'Language',
          'es' => 'Idioma'
      ],
      'explore' => [
          'zh' => '探索',
          'en' => 'Explore',
          'es' => 'Explorar'
      ],
      'team' => [
          'zh' => '團隊',
          'en' => 'Team',
          'es' => 'Equipo'
      ],
      'vanishing_acts_url' => [
          'zh' => 'https://dev.8f-2.cc/vanishing_acts02/',
          'en' => 'https://dev.8f-2.cc/vanishing_acts02/en/home_en',
          'es' => 'https://dev.8f-2.cc/vanishing_acts02/es/home_es'
      ],
      'netopen_url' => [
          'zh' => 'https://tfam-netopen.xyz',
          'en' => 'https://tfam-netopen.xyz/en/home/',
          'es' => 'https://tfam-netopen.xyz/en/home/'
      ],

  ];

  // 生成多語言 span 的函數
  function generate_multilang_span($texts, $additional_class = '') {
      $html = '';
      foreach ($texts as $lang => $text) {
          $class = "lang-{$lang}";
          if ($additional_class) {
              $class .= " {$additional_class}";
          }
          $html .= "<span class=\"{$class}\">{$text}</span>";
      }
      return $html;
  }
  ?>

  <nav id="va-mob-nav" class="va-mob-nav" aria-label="Primary">
      <a class="va-mob-nav__item" href="#sec-about" data-scroll="">
          <?= generate_multilang_span($nav_texts['about']) ?>
      </a>
      <a class="va-mob-nav__item" href="#sec-whatson" data-scroll="">
          <?= generate_multilang_span($nav_texts['whatson']) ?>
      </a>
      <a class="va-mob-nav__item" href="#sec-program" data-scroll="">
          <?= generate_multilang_span($nav_texts['program']) ?>
      </a>
      <button class="va-mob-nav__item va-mob-nav__more" type="button" data-open-more="">
          <?= generate_multilang_span($nav_texts['more']) ?>
      </button>
  </nav>

  <div id="va-more" class="va-more" role="dialog" hidden="" aria-hidden="true" aria-modal="true" aria-label="More">
      <div class="va-more__backdrop" data-close-more=""></div>
      <div class="va-more__panel">
          <button class="va-more__close color23e2d0" aria-label="Close" data-close-more="">
              <i class="fa fa-times" aria-hidden="true"></i>
          </button>
          
          <section class="va-more__section">
              <h5><?php generate_multilang_span($nav_texts['language']) ?></h5>
              <div class="text-info"><a href="<?php echo $nav_texts['vanishing_acts_url']['zh']; ?>" target="_blank">中文</a></div>
              <div class="text-info"><a href="<?php echo $nav_texts['vanishing_acts_url']['en']; ?>" target="_blank">English</a></div>
              <div class="text-info"><a href="<?php echo $nav_texts['vanishing_acts_url']['es']; ?>" target="_blank">Español</a></div>
          </section>
          
          <section class="va-more__section">
              <h5><?= generate_multilang_span($nav_texts['explore']) ?></h5>
              <div class="text-info">
                  <a href="#sec-team" data-scroll="" data-close-more="">
                      <?= generate_multilang_span($nav_texts['team']) ?>
                  </a>
              </div>
              <div class="text-info">
                  <a href="https://tfam-netopen.xyz" target="_blank" rel="noopener" class="lang-zh">TFAM Net.Open</a>
                  <a href="https://tfam-netopen.xyz/en/home/" target="_blank" rel="noopener" class="lang-en">TFAM Net.Open</a>
                  <a href="https://tfam-netopen.xyz/en/home/" target="_blank" rel="noopener" class="lang-es">TFAM Net.Open</a>
              </div>
          </section>
      </div>
  </div>
	</body>
</html>