<?php

	add_action( 'wp_enqueue_scripts', 'ohio_child_local_enqueue_parent_styles' );

	function ohio_child_local_enqueue_parent_styles() {
		wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	}


// ① 註冊一個側欄選單位置
add_action('after_setup_theme', function(){
  register_nav_menus([
    'va_side' => __('Vanishing Acts – Side Menu','va'),
  ]);
});

// ② 只在首頁（或指定頁面）啟用左側固定選單：加 body class
add_filter('body_class', function($classes){
  if (is_front_page() || is_page('vanishing-acts')) { // ← 依你的實際頁面調整條件
    $classes[] = 'va-leftnav';
  }
  return $classes;
});

// ③ 在 <body> 打開後插入側邊選單（不改 header.php）
add_action('wp_body_open', function(){
  if (!in_array('va-leftnav', get_body_class(), true)) return;

  ?>
  <aside id="va-sidebar" class="va-sidebar" aria-label="Vanishing Acts menu">
    <div class="va-brand"><span class="lang-es"><img src="https://dev.8f-2.cc/vanishing_acts02/wp-content/uploads/2025/09/logo_en_es_v5.png"></span><span class="lang-zh"><img src="https://dev.8f-2.cc/vanishing_acts02/wp-content/uploads/2025/09/logo_en_zh_v3.png"></span><span class="lang-en"><img src="https://dev.8f-2.cc/vanishing_acts02/wp-content/uploads/2025/09/logo_en_zh_v3.png"></span></div>

    <?php
    // WordPress 選單（去 外觀→選單 指派到 "Vanishing Acts – Side Menu"）
    wp_nav_menu([
      'theme_location' => 'va_side',
      'container'      => 'nav',
      'container_class'=> 'va-sidelinks',
      'menu_class'     => 'va-nav',
      'fallback_cb'    => false,
    ]);
    ?>
  </aside>
  <?php
});

// ④（選配）為了平滑捲動 anchor
add_action('wp_enqueue_scripts', function(){
  wp_add_inline_script('jquery-core', 'document.addEventListener("click",function(e){var a=e.target.closest("a[href^=\'#\']");if(!a)return;var id=a.getAttribute("href");if(id.length>1){var t=document.querySelector(id);if(t){e.preventDefault();var y=t.getBoundingClientRect().top+window.scrollY;window.scrollTo({top:y-12,behavior:"smooth"});}}});');
});

// 在選單項目後台加入一個可換行的自訂欄位
add_action('wp_nav_menu_item_custom_fields', function($item_id, $item, $depth, $args){
  // 只在你側欄用的那組選單出現（可移除此判斷，讓所有選單都有）
  // if (empty($args->theme_location) || $args->theme_location !== 'va_side') return;

  $val = get_post_meta($item_id, '_va_desc', true);
  ?>
  <p class="field-va-desc description description-wide">
    <label for="edit-menu-item-va-desc-<?php echo esc_attr($item_id); ?>">
      VA Side Description（可換行）
      <textarea id="edit-menu-item-va-desc-<?php echo esc_attr($item_id); ?>"
                class="widefat code edit-menu-item-va-desc"
                name="menu-item-va-desc[<?php echo esc_attr($item_id); ?>]"
                rows="4"><?php echo esc_textarea($val); ?></textarea>
      <span class="description">
        每一行會照順序顯示；若要在上下兩段之間加「點點分隔」，請單獨一行輸入 <code>...</code>。
      </span>
    </label>
  </p>
  <?php
}, 10, 4);

// 儲存自訂欄位
add_action('wp_update_nav_menu_item', function($menu_id, $menu_item_db_id, $args){
  if (isset($_POST['menu-item-va-desc'][$menu_item_db_id])) {
    // 原樣存文字（保留換行），前端再決定怎麼轉 HTML
    $val = wp_unslash($_POST['menu-item-va-desc'][$menu_item_db_id]);
    update_post_meta($menu_item_db_id, '_va_desc', $val);
  } else {
    delete_post_meta($menu_item_db_id, '_va_desc');
  }
}, 10, 3);

// 讀出來放到 $item 物件上
add_filter('wp_setup_nav_menu_item', function($item){
  $item->va_desc = get_post_meta($item->ID, '_va_desc', true);
  return $item;
});


// 只對側欄選單（va_side）在錨點<a>後面輸出描述
add_filter('walker_nav_menu_start_el', function($item_output, $item, $depth, $args){
  if (empty($args->theme_location) || $args->theme_location !== 'va_side') {
    return $item_output;
  }
  if (empty($item->va_desc)) return $item_output;

  // 將純文字描述轉為 HTML：
  // - 每一行保留為 <br>
  // - 單獨一行為 "..." 時，輸出點點分隔符
  $lines = preg_split("/\r\n|\r|\n/", $item->va_desc);
  $html  = '';
  $buffer = [];

  $flush_para = function() use (&$buffer, &$html){
    if (!empty($buffer)) {
      // 將行內的文字安全輸出並以 <br> 連接
      $html .= '<p>'.implode('<br>', array_map('esc_html', $buffer)).'</p>';
      $buffer = [];
    }
  };

  foreach ($lines as $line) {
    if (trim($line) === '...') {
      $flush_para();
      $html .= '<div class="va-dots" aria-hidden="true">• • •</div>';
    } else {
      $buffer[] = $line;
    }
  }
  $flush_para();

  // 包一層容器，接在 <a> 後面
  $item_output .= '<div class="menu-description va-side-desc">'.$html.'</div>';
  return $item_output;
}, 10, 4);