<?php
/**
 * Ohio WordPress Theme
 *
 * Theme header template
 *
 * @author Colabrio
 * @link   https://ohio.clbthemes.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get theme options
$wrapper_boxed = OhioOptions::get( 'page_use_boxed_wrapper', false );
$show_header = OhioOptions::get( 'page_header_visibility', true ) && !OhioSettings::page_is( 'for_builder' ) && !OhioSettings::is_coming_soon_page();
$show_header_subheader = OhioSettings::subheader_is_displayed();
$show_offer_banner = OhioOptions::get( 'page_offer_banner', false );
$header_layout = OhioOptions::get( 'page_header_menu_style', 'style1' );
$header_spacer = OhioOptions::get( 'page_header_add_cap', true );
$mobile_menu = OhioOptions::get_global( 'page_mobile_menu_initial_resolution' );

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php
		// Start bufferization to compute all dynamic CSS styles to show it before <body>
		// OhioBuffer::start_content_bufferization();

		wp_head();
	?>
  <style>
    #va-sidebar, #page {
      opacity: 0;animation: fadeIn 5s ease-in-out forwards;
     /* forwards 讓動畫結束後保持最終狀態 */
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
      }
      to {
        opacity: 1;
      }
    }
  </style>
	<style>

* {
  margin: 0;
  padding: 0;
  outline: none;
  list-style: none;
  text-decoration: none;
  box-sizing: border-box;
  background: transparent;
  border: none;
}
.card {
  position: absolute;
  z-index: 10;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  user-select: none;
  max-width: 600px;
  padding: 48px;
  -webkit-backdrop-filter: blur(10px);
  backdrop-filter: blur(10px);
  border-radius: 8px;
  box-shadow: 0 4px 90px rgba(0, 0, 0, 0.1);
  overflow: hidden;
}
.card:before {
  content: "";
  position: absolute;
  z-index: 2;
  top: 0;
  left: 0;
  width: 100%;
  height: 2px;
  background: white;
  background: linear-gradient(90deg, rgba(255, 255, 255, 0) 0%, white 34%, white 89%, rgba(255, 255, 255, 0) 100%);
  opacity: 0.3;
  filter: blur(0.5px);
  mix-blend-mode: hard-light;
}
.card .noise {
  position: absolute;
  top: 0;
  left: 0;
  height: 100%;
  width: 100%;
  z-index: 1;
  opacity: 0.1;
}
.card .content {
  position: relative;
  z-index: 2;
  text-shadow: -3px 0px 2px rgba(0, 0, 0, 0.1);
}
.hero-video { will-change: opacity, transform, filter; backface-visibility: hidden; }

	</style>
  <link rel="preload" as="video" href="https://tfam-netopen-project.s3.ap-southeast-1.amazonaws.com/va_web_pal.mp4" type="video/mp4" crossorigin="anonymous">

</head>
<body <?php body_class(); ?>>

<div class="hero-video-wrap">

  <video id="heroVideo" class="hero-video"
         autoplay muted playsinline loop preload="auto">
    <!-- 手機（寬度 < 575px） -->
    <source src="https://tfam-netopen-project.s3.ap-southeast-1.amazonaws.com/va_mobile_pal.mp4"
            type="video/mp4" media="(max-width: 575px)">
    <!-- 桌機／平板 -->
    <source src="https://tfam-netopen-project.s3.ap-southeast-1.amazonaws.com/va_web_pal.mp4"
            type="video/mp4" media="(min-width: 576px)">
    Your browser does not support the video tag.
  </video>
  <!-- 無 JS 的保險底圖 -->
  <noscript>
    <style>
      .hero-video-wrap{background:#000 url('https://dev.8f-2.cc/vanishing_acts02/dist/web_bg.jpg') center/cover no-repeat;}
      @media (max-width:575px){.hero-video-wrap{background-image:url('https://dev.8f-2.cc/vanishing_acts02/dist/mobile_bg.jpg');}}
    </style>
  </noscript>
</div>

<!-- CSS -->
<style>
.hero-video-wrap{
  position: absolute;
  width: 100%;
  height: 100svh;
  min-height: 100vh;
  overflow: hidden;
}

.hero-video{
  position: fixed;
  inset: 0;
  width: 100vw;
  height: 100svh;
  min-height: 100vh;
  object-fit: cover;
  pointer-events: none;
  
  /* 一開始作為蓋板，在最前面 */
  z-index: 99999;
  opacity: 1;
  
  /* 絲滑的轉場過渡 */
  transition: 
    opacity 4s cubic-bezier(0.25, 0.1, 0.25, 1),
    transform 5s cubic-bezier(0.165, 0.84, 0.44, 1),
    filter 3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

/* 絲滑優雅的背景轉場動畫 */
@keyframes silkyRetreat {
  0% {
    z-index: 99999;
    opacity: 1;
  }
  
  15% {
    opacity: 0.95;
  }
  
  35% {
    opacity: 0.85;
  }
  
  60% {
    opacity: 0.7;
  }
  
  80% {
    opacity: 0.5;
  }
  
  95% {
    opacity: 0.3;
    z-index: 9999;
  }
  
  100% {
    z-index: -3;
    opacity: 0.25;
  }
}

.hero-video.silky-retreat {
  animation: silkyRetreat 6s cubic-bezier(0.19, 1, 0.22, 1) forwards;
}

/* 載入期間的蓋板效果 */
.hero-video.cover-mode {
  z-index: 99999;
  opacity: 1;
}

/* 最終背景狀態 */
.hero-video.background-mode {
  z-index: -3;
}

/* 響應式調整 */
@media (max-width: 768px) {
  @keyframes silkyRetreat {
    0% {
      z-index: 99999;
      opacity: 1;
    }
    
    20% {
      opacity: 0.9;
    }
    
    50% {
      opacity: 0.6;
    }
    
    85% {
      opacity: 0.3;
    }
    
    100% {
      z-index: -3;
      opacity:0.25 ;
    }
  }
}
</style>

<!-- JavaScript -->
<script>
(function(){
  const v = document.getElementById('heroVideo');
  if (!v) return;
  
  // 影片轉場狀態管理
  let transitionStarted = false;
  let transitionCompleted = false;
  
  // 依斷點切換載入前海報圖
  const MOBILE_POSTER  = 'https://dev.8f-2.cc/vanishing_acts02/dist/mobile_bg.jpg';
  const DESKTOP_POSTER = 'https://dev.8f-2.cc/vanishing_acts02/dist/web_bg.jpg';
  const mq = window.matchMedia('(max-width: 575px)');
  
  function applyPoster(){ 
    v.poster = mq.matches ? MOBILE_POSTER : DESKTOP_POSTER; 
  }
  
  applyPoster();
  if (mq.addEventListener) mq.addEventListener('change', applyPoster);
  else mq.addListener(applyPoster);
  
  // 確保影片設定
  function prime(){
    v.muted = true; 
    v.setAttribute('muted','');
    v.setAttribute('playsinline',''); 
    v.setAttribute('webkit-playsinline','');
    v.autoplay = true; 
    v.setAttribute('autoplay','');
    v.loop = true; 
    v.preload = 'auto';
    
    // 初始狀態：蓋板模式
    v.classList.add('cover-mode');
  }
  
  prime();
  
  function tryPlay(){
    const p = v.play();
    if (p && p.catch) p.catch(()=>{ /* 處理播放失敗 */ });
  }
  
  // 開始絲滑優雅的轉場動畫
  function startSilkyTransition() {
    if (transitionStarted) return;
    transitionStarted = true;
    
    console.log('Starting silky elegant transition to background...');
    
    // 移除蓋板模式
    v.classList.remove('cover-mode');
    
    // 開始絲滑退場動畫
    v.classList.add('silky-retreat');
    
    // 動畫完成後設定最終狀態
    setTimeout(() => {
      if (!transitionCompleted) {
        transitionCompleted = true;
        v.classList.remove('silky-retreat');
        v.classList.add('background-mode');
        console.log('Silky transition completed - video now in background');
      }
    }, 6000); // 6秒動畫完成
  }
  
  // 頁面載入後3秒開始轉場
  function scheduleTransition() {
    setTimeout(() => {
      startSilkyTransition();
    }, 3000); // 3秒後開始轉場
  }
  
  // 影片載入完成後開始播放和計時
  if (v.readyState >= 2) {
    tryPlay();
    scheduleTransition();
  } else {
    v.addEventListener('canplay', function oncp(){ 
      v.removeEventListener('canplay', oncp); 
      tryPlay();
      scheduleTransition();
    });
  }
  
  // 頁面載入完成的後備方案
  window.addEventListener('load', () => {
    if (!transitionStarted) {
      setTimeout(() => {
        startSilkyTransition();
      }, 100); // 頁面載入後1.5秒
    }
  });
  
  // 後備：用戶互動時嘗試播放
  const nudge = () => { 
    tryPlay(); 
    cleanup(); 
  };
  
  function cleanup(){
    window.removeEventListener('pointerdown', nudge);
    window.removeEventListener('keydown', nudge);
    window.removeEventListener('touchstart', nudge);
  }
  
  window.addEventListener('pointerdown', nudge, { once: true });
  window.addEventListener('keydown', nudge, { once: true });
  window.addEventListener('touchstart', nudge, { once: true });
  
  // 回到可見頁時若暫停，重新播放
  document.addEventListener('visibilitychange', () => {
    if (!document.hidden && v.paused) tryPlay();
  });
  
  // 提供手動控制函數
  window.VideoTransitionControl = {
    startTransition: function() {
      startSilkyTransition();
    },
    resetToCover: function() {
      transitionStarted = false;
      transitionCompleted = false;
      v.classList.remove('silky-retreat', 'background-mode');
      v.classList.add('cover-mode');
      v.style.zIndex = '9999';
      console.log('Video reset to cover mode');
    },
    skipToBackground: function() {
      if (!transitionCompleted) {
        v.classList.remove('cover-mode', 'silky-retreat');
        v.classList.add('background-mode');
        transitionCompleted = true;
        console.log('Video immediately moved to background');
      }
    },
    getStatus: function() {
      return {
        transitionStarted: transitionStarted,
        transitionCompleted: transitionCompleted,
        currentZIndex: window.getComputedStyle(v).zIndex,
        classes: Array.from(v.classList),
        opacity: window.getComputedStyle(v).opacity
      };
    }
  };
  
})();
</script>

<!-- 在 <body> 標籤後面新增 -->
<button id="va-hamburger" aria-label="Open menu" style="display: none;">
  <span></span>
</button>
<div class="va-brand_mobile"><span class="lang-es"><img width="200px" src="https://dev.8f-2.cc/vanishing_acts02/wp-content/uploads/2025/09/logo_en_es_v5.png"></span><span class="lang-zh"><img width="200px" src="https://dev.8f-2.cc/vanishing_acts02/wp-content/uploads/2025/09/logo_en_zh_v3.png"></span><span class="lang-en"><img width="200px"  src="https://dev.8f-2.cc/vanishing_acts02/wp-content/uploads/2025/09/logo_en_zh_v3.png"></div>

<!-- 側邊欄遮罩 -->
<div id="va-sidebar-overlay"></div>
	<?php wp_body_open(); ?>
	<?php
		if ( function_exists( 'elementor_theme_do_location' ) ) {
			$elementor_header = elementor_theme_do_location( 'header' );
			$show_header = $show_header && ! $elementor_header;
		}
	?>
	<div id="page" class="site">

		<?php if ( $wrapper_boxed ) : ?>

		<div class="boxed-container">

		<?php endif; ?>

		<div id="content" class="site-content" data-mobile-menu-resolution="<?php echo esc_attr( isset( $mobile_menu ) ? $mobile_menu : '' ); ?>">

			<?php if ( isset( $show_header ) && $header_spacer && $show_header ) : ?>

			<div class="header-cap<?php echo esc_attr( $header_cap_class ); ?>"></div>

			<?php endif; ?>